VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SonarClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' Sonar Class
'
Option Explicit

Const JOYSTICKID1 = 0

Public Enum ParityValue
  pvNone
  pvOdd
  pvEven
  pvMark
  pvSpace
End Enum

Public Enum TimerModes

  tmIdle
  tmPing
  tmWakeup

End Enum

Public Enum BandwidthT
  bw50 = 1
  bw25
  bw12_5
  bw6_25
End Enum

Public Enum SonarDataFlagsT
  sonarDataTimeSeries = 1
  sonarDataMatchedFilter = 2
  sonarDataEchoes = 4
End Enum

Public Enum PulseTypeT
  broadband = 1
  cw
  sweep
End Enum

Public Enum ReceiverGainT
  rgLow
  rgMedium
  rgHigh
  rgVeryHigh
End Enum

Public Enum SonarModeT
  manualPlayback
  automaticPlayback
  manualTransducer
  automaticTransducer
End Enum

Private Enum SonarParameterCodeT
  ssBandwidth
  ssNarrowBeam
  ssPingInterval
  ssPingManually
  ssPulseLength
  ssPulseType
  ssReceiverGain
  ssSpeedOfSound
  ssStartFrequency
  ssStopFrequency
  ssTransmitPower
  ssWakeup
  ssError
  ssLength
End Enum

Public Enum SonarStatusT
  sonarAwake
  playback
  Unknown
End Enum

Public Event EndOfPingSeries()
Public Event PingReceived()
Public Event PingRequested()

Private mConfiguration As SonarConfigurationClass
Private mIsLoopPlayback As Boolean
Private mIsPaused As Boolean
Private mIsPinging As Boolean
Private mIsPlayback As Boolean           ' true if in playback mode
Private mIsPlaybackPingNumber As Long    ' number of ping to playback
Private mNPingsLost As Long
Private mPingCount As Long               ' number of pings in a playback ping series
Private mPingInterval As Long ' in milliseconds
Private mPingManually As Boolean ' true if pings requested manually
Private mPingNumber As Long
Private mPingRequestTime As SYSTEMTIME ' time when ping was requested (ms resolution)
Private mSonarIsInitialized As Boolean ' true if SonarOCX has been initialized
Private mSonarIsRdi2 As Boolean
Private WithEvents mTimer As Timer ' timer used to control auto pinging, etc.
Attribute mTimer.VB_VarHelpID = -1
Private mTimerMode As Integer       ' current use of timer

Private detectionSignalLength As Long
Private detectionSignal() As Single
Private echoes As Collection
Private nEchoes As Long
Private timeSeries() As Single
Private timeSeriesLength As Long

Private AdcMaxVoltage As Single
Private AdcMinVoltage As Single
Private Bandwidth As BandwidthT
Private bandwidthTable(-1 To bw6_25) As String
Private bottomDetectFalloffRatio As Single
Private bottomDetectStartRange As Single
Private bottomDetectThreshold As Single
Private bottomDetectWindowSize As Integer
Private echoDetectPeakSeparation As Single
Private echoDetectPeakThreshold As Single
Private echoDetectTargetStrengthThreshold As Single
Private echoDetectWindowSize As Integer
Private echoDetectAvgMaxRange As Single
Private exemplarFFTSize As Integer
Private errorMessage As String
Private narrowBeam As Boolean
Private notes As String
Private pingInProgress As Boolean  ' True when a ping is requested and
                                   ' goes to false when ping arrives
Private pingInterval As Long            ' in s/100
Private pingLatitude As Double
Private pingListeners As New Collection
Private pingLogging As Boolean
Private pingLongitude As Double
Public pingSamples As Variant
Private pingSamplesInternal() As Single
Private pingSeriesID As String    ' Universally unique id for a ping series
Private pingSeriesName As String  ' Human name for the ping series (optional)
Private pingTime As Date
Private playbackDataSource As String
Private playbackFile As Integer
Private pulseType As PulseTypeT
Private pulseLength As Long             ' in cm  ??? s/b either mm or m
Private sampleCount As Long
Private SamplingPeriod As Long          ' in nanoseconds
Private Const sig_header As Integer = 26
Private speedOfSound As Long            ' in m/s
Private receiverGain As ReceiverGainT
Private receiverGainTable(-1 To rgVeryHigh) As String
Private salinity As Long
Private sonarDataFlags As Integer
Private sonarIsAwake As Boolean
Private sonarMode As SonarModeT
Private WithEvents SonarOCX As SonarSystem
Attribute SonarOCX.VB_VarHelpID = -1
'Private sonarParameters As New SonarParametersClass
Private SonarStatus As SonarStatusT
Private startFrequency As Long          ' in Hz
Private stopFrequency As Long          ' in Hz
'  Variables for use in ADCP synchronization.

Private syncDelay As Long              ' in ms
Private syncDelayMax As Long            ' in ms (ping must start before this time)
Private syncEnabled As Boolean
Private syncPrevious As SYSTEMTIME ' time of accepted pulse

Public trx As TrackerClass                ' Serves as an interface to the OCX implementation of the tracker
Private Const className = "SonarClass."   ' class name

Private transducerID As String          ' unique id for the sonar transducer
Private transmitPower As Integer

Private lastSonarError As String   ' used to avoid hitting the operator w/ repeated error messages i.e. "the Dapl error" - REB

Public Sub addPingListener(anObject As Object, ByVal dataFlags As SonarDataFlagsT)
'
'Call this routine to request notification when a ping comes in.
'The form's pingArrived routine (no args) will be called.
'Use the dataFlags variable to indicate what types of data are
'needed (e.g., time series, echoes, etc.).  Use constants in
'SonarDataFlagsT enum.

  Dim listener As PingListener
  Set listener = New PingListener
  listener.constructor anObject, dataFlags
  removePingListener anObject ' Just for safety
  pingListeners.Add listener
  sonarDataFlags = sonarDataFlags Or dataFlags
  
End Sub

Public Function BlobToArray(blob, theArray) As Boolean

  BlobToArray = SonarOCX.BlobToArray(blob, theArray)

End Function

Public Function closePingfile()

  IllegalForPlaybackMode
  SonarOCX.closePingfile

End Function

Public Sub closePlaybackFile()

  If playbackFile <> 0 Then Close #playbackFile

End Sub

Private Sub ConfigureSonarOCX()

  On Error GoTo rethrowIt
  
  Debug.Assert ((mIsPlayback Or sonarIsAwake Or mSonarIsRdi2) And Not mIsPinging)
  
  '  Send the entire set of processing parameters down to the sonar OCX
  
  ' Sonar Parameters
  ' ----------------
  
  With mConfiguration
  
    AdcMaxVoltage = .GetValue("AdcMaxVoltage")
    AdcMinVoltage = .GetValue("AdcMinVoltage")
    Bandwidth = .GetValue("Bandwidth")
    narrowBeam = .GetValue("beamAngle") < 50
    pulseLength = .GetValue("pulseLength")
    pulseType = .GetValue("pulseType")
    receiverGain = .GetValue("receiverGain")
    sampleCount = .GetValue("sampleCount")
    SamplingPeriod = .GetValue("SamplingPeriod")
    speedOfSound = NominalSoundSpeed
    startFrequency = .GetValue("startFrequency")
    stopFrequency = .GetValue("stopFrequency")
    transmitPower = .GetValue("transmitPower")
     
    SonarOCX.AdcMaxVoltage = .GetValue("AdcMaxVoltage")
    SonarOCX.AdcMinVoltage = .GetValue("AdcMinVoltage")

    If mSonarIsRdi2 Then
      Dim gain As Integer
      Dim pulse As Double
      Dim sampleLength As Double
      gain = limitL(0, .GetValue("receiverGain"), 7)
      pulse = GetBestMatchD(.GetValue("pulseLength") / 100, 1, 2, 4, 8)
      pulse = CLng(Log(pulse) / Log(2))
      sampleLength = GetBestMatchD(.GetValue("sampleCount"), _
                                   33333, 66667, 100000, 133333, 166666, 200000, 233333, 266667)
      sampleLength = CLng(sampleLength / 33333) - 1
      SamplingPeriod = 2000 ' ns; 1/500000kHz x 1e9 ns/s
      SonarOCX.SetSonarParameters2 gain, pulse, 0, sampleLength, False
    Else
      SonarOCX.Bandwidth = .GetValue("Bandwidth")
      SonarOCX.narrowBeam = .GetValue("beamAngle") > 5
      SonarOCX.pulseLength = .GetValue("pulseLength")
      SonarOCX.pulseType = .GetValue("pulseType")
      SonarOCX.receiverGain = .GetValue("receiverGain")
      SonarOCX.sampleCount = .GetValue("sampleCount")
      SonarOCX.SamplingPeriod = .GetValue("SamplingPeriod")
      SonarOCX.speedOfSound = NominalSoundSpeed
      SonarOCX.startFrequency = .GetValue("startFrequency")
      SonarOCX.stopFrequency = .GetValue("stopFrequency")
      SonarOCX.transmitPower = .GetValue("transmitPower")
    End If
       
  End With
  
  ' Bottom Detection
  ' ----------------
  
  With mConfiguration
    SonarOCX.SetBottomDetectionParameters .GetValue("bottomDetectFalloffRatio"), _
      .GetValue("bottomDetectStartRange"), _
      .GetValue("bottomDetectThreshold"), _
      .GetValue("bottomDetectWindowSize")
  End With

  ' Echo Detection
  ' --------------
  
  With mConfiguration
    SonarOCX.SetEchoDetectionParameters .GetValue("echoCorrelationThreshold"), _
      .GetValue("echoSeparation"), _
      .GetValue("echoWindowSize"), _
      .GetValue("echoTsThreshold"), _
      .GetValue("echoAvgMaxRange")
    SonarOCX.exemplarFFTSize = .GetValue("exemplarFFtSize")
  End With
  
  ' Classifier
  ' ----------
  
  Dim classifier As ClassifierClass
  Set classifier = mConfiguration.GetClassifier()
  If classifier Is Nothing Then
    SonarOCX.SetClassifier "", 0, 0, 0, 0 ' Remove classifier from OCX - JG
  Else
    With classifier
      Dim filename As String
      filename = general.appOrigin & "\data\netexport.net"
      classifier.ExportNet (filename)
      SonarOCX.SetClassifier filename, .GetNClasses(), .GetFirstBin(), _
                             .GetNBins(), .GetSamplingPeriod()
    End With
  End If
  
  ' Replica
  ' -------
  
  Dim replica As ReplicaClass
  Set replica = mConfiguration.GetReplica
  If replica Is Nothing Then
    SonarOCX.SetUseStoredReplica False
  Else
    SonarOCX.SetUseStoredReplica True
    With replica
      SonarOCX.SetReplica .SamplingPeriod, .Bandwidth, replica.waveform
    End With
  End If
  
  Exit Sub
  
rethrowIt:

  Rethrow "ConfigureSonarOCX"
  
End Sub

Public Function Construct(theSonarOCX As SonarSystem, aTimer As Timer)

  Set SonarOCX = theSonarOCX
  Set mTimer = aTimer
  SonarOCX.SetBaseDirectory general.appOrigin
  GetSystemTime syncPrevious
  syncEnabled = general.propertyList.GetProperty("Norway:useAdcpSync", False)
  If syncEnabled Then
    syncDelay = general.propertyList.GetProperty("Norway:delay", 1000)
    syncDelayMax = general.propertyList.GetProperty("Norway:delayMax", 1200)
    On Error GoTo oops
    SonarOCX.SetButtonChangeCapture True, JOYSTICKID1
  End If
  
  Exit Function
  
oops:

  MsgBox "Could not connect to sync device, reverting to unsynched mode." & _
         vbCrLf & "Reason: " & Err.description, vbExclamation + vbOKOnly, _
         "Unable to Sync"
  syncEnabled = False
  general.propertyList.SetProperty "Norway:useAdcpSync", False
    
End Function
Public Function GetAdcMaxVoltage() As Single

  GetAdcMaxVoltage = AdcMaxVoltage

End Function
Public Function GetAdcMinVoltage() As Single

  GetAdcMinVoltage = AdcMinVoltage

End Function

Public Function GetBandwidth() As BandwidthT

  GetBandwidth = Bandwidth

End Function
Private Sub GetBottomDetectionParameters()

  SonarOCX.GetBottomDetectParameters bottomDetectFalloffRatio, _
                                     bottomDetectStartRange, _
                                     bottomDetectThreshold, _
                                     bottomDetectWindowSize

End Sub
Public Function GetBottomDetectFalloffRatio() As Single

  GetBottomDetectionParameters
  GetBottomDetectFalloffRatio = bottomDetectFalloffRatio
  
End Function
Public Function GetBottomDetectStartRange() As Single

  GetBottomDetectionParameters
  GetBottomDetectStartRange = bottomDetectStartRange
  
End Function
Public Function GetBottomDetectThreshold() As Single

  GetBottomDetectionParameters
  GetBottomDetectThreshold = bottomDetectThreshold
  
End Function
Public Function GetBottomDetectWindowSize() As Single

  GetBottomDetectionParameters
  GetBottomDetectWindowSize = bottomDetectWindowSize
  
End Function
Public Function GetClassifier() As ClassifierClass

  If mConfiguration Is Nothing Then
    Set GetClassifier = Nothing
  Else
  Set GetClassifier = mConfiguration.GetClassifier
  End If
End Function
Public Function GetDetectionSignal() As Single()

  GetDetectionSignal = detectionSignal

End Function
Public Function GetDetectionSignalLength() As Long

  GetDetectionSignalLength = detectionSignalLength

End Function
Public Function GetEcho(ByVal echoNumber As Long) As EchoClass

  Set GetEcho = echoes(echoNumber + 1)
     ' echoes is a collection which is one-based

End Function
Private Sub GetEchoDetectionParameters()

  SonarOCX.GetEchoDetectionParameters echoDetectPeakThreshold, _
                                      echoDetectPeakSeparation, _
                                      echoDetectWindowSize, _
                                      echoDetectTargetStrengthThreshold, _
                                      echoDetectAvgMaxRange

End Sub
Public Function GetExemplarFFTSize() As Long

  GetExemplarFFTSize = SonarOCX.exemplarFFTSize()

End Function
Public Function GetMaxRange() As Single

  GetMaxRange = SampleToRange(sampleCount, speedOfSound, SamplingPeriod)

End Function

Public Function GetNarrowBeam() As Boolean

  GetNarrowBeam = narrowBeam

End Function
Public Function GetNEchoes() As Long

  GetNEchoes = nEchoes

End Function

Public Function GetNoiseWindowSize() As Long

  GetNoiseWindowSize = SonarOCX.noiseWindowSize

End Function
Public Function GetNoiseThreshold() As Single

  GetNoiseThreshold = SonarOCX.noiseThreshold

End Function
Public Function GetNotes() As String

  GetNotes = notes

End Function
Public Function getNPingsLost() As Long

  getNPingsLost = mNPingsLost

End Function
Public Function GetPeakWindowSize() As Long

  GetEchoDetectionParameters
  GetPeakWindowSize = echoDetectWindowSize

End Function
Public Function GetPeakSeparation() As Single

  GetEchoDetectionParameters
  GetPeakSeparation = echoDetectPeakSeparation

End Function
Public Function GetPeakThreshold() As Single

  GetEchoDetectionParameters
  GetPeakThreshold = echoDetectPeakThreshold

End Function
Public Function GetPingFilename() As String

  IllegalForPlaybackMode
  GetPingFilename = SonarOCX.PingFilename
  
End Function
Public Function GetPingInterval() As Long

  GetPingInterval = pingInterval

End Function
Public Function GetPingLatitude() As Date

  GetPingLatitude = pingLatitude

End Function
Public Function GetPingLongitude() As Date

  GetPingLongitude = pingLongitude

End Function
Public Function GetPingSeriesID() As String

  GetPingSeriesID = pingSeriesID

End Function
Public Function GetPingTime() As Date

  GetPingTime = pingTime

End Function
Public Function GetSonarConfiguration() As SonarConfigurationClass

  Set GetSonarConfiguration = mConfiguration

End Function
Public Function IsRdi2() As Boolean

  If Not mSonarIsInitialized Then
    SonarInitialize
  End If
  
  IsRdi2 = mSonarIsRdi2

End Function
Public Function IsManualPing() As Boolean

  IsManualPing = mPingManually

End Function

Public Function GetPulseLength() As Long

  GetPulseLength = pulseLength

End Function

Public Function GetPulseType() As PulseTypeT

  GetPulseType = pulseType

End Function

Public Function GetPingSeriesName() As String

  GetPingSeriesName = pingSeriesName

End Function
Public Function GetPulseDescription() As String

  Select Case pulseType
    
    Case broadband
      
      GetPulseDescription = "broadband (" & bandwidthTable(Bandwidth) & _
                            ", " & Format(startFrequency / 1000, "##0.0##") & _
                            " KHz)"
    
    Case cw
    
      GetPulseDescription = "CW (" & Format(startFrequency / 1000, "##0.0##") & _
                            " KHz)"
    
    Case sweep
    
      GetPulseDescription = "Sweep (" & Format(startFrequency / 1000, "##0.0##") & _
                            " to " & Format(stopFrequency / 1000, "##0.0##") & " KHz)"
    
  End Select
  

End Function

Public Function GetReceiverGain() As ReceiverGainT

  GetReceiverGain = receiverGain

End Function
Public Function GetReceiverGainDescription() As String

  GetReceiverGainDescription = receiverGainTable(receiverGain)

End Function
Public Function GetSalinity() As Long

  GetSalinity = salinity

End Function
Public Function GetSampleCount() As Long

  GetSampleCount = sampleCount

End Function
Public Function GetSamplingPeriod() As Long

  GetSamplingPeriod = SamplingPeriod

End Function
Public Function GetSpeedOfSound() As Integer

  GetSpeedOfSound = speedOfSound

End Function
Public Function GetStartFrequency() As Long

  GetStartFrequency = startFrequency

End Function
Public Function GetStopFrequency() As Long

  GetStopFrequency = stopFrequency

End Function
Public Function GetTargetStrengthThreshold() As Single

  GetEchoDetectionParameters
  GetTargetStrengthThreshold = echoDetectTargetStrengthThreshold

End Function
Public Function GetTimeSeries() As Single()

  GetTimeSeries = timeSeries

End Function
Public Function GetTimeSeriesLength() As Long

  GetTimeSeriesLength = timeSeriesLength

End Function
Public Function GetTransmitPower() As Integer

  GetTransmitPower = transmitPower

End Function
Public Function GetTransducerID() As String

  GetTransducerID = transducerID

End Function

Private Sub IllegalForPlaybackMode()

 ' Debug.Assert (False)
'  If playbackMode Then
'    Err.Raise vbObjectError + 1, , "Operation not legal during playback."
'  End If

End Sub
Private Function InstallPlaybackSonarConfiguration() As Boolean

  On Error GoTo rethrowIt

  '  Returns true if successful

  Dim playbackConfiguration As SonarConfigurationClass
  Set playbackConfiguration = New SonarConfigurationClass
  InstallPlaybackSonarConfiguration = playbackConfiguration.ReadFromDB(dbToUse:=general.pingDB, _
                                   pingSeriesID:=pingSeriesID, ReadOnly:=True)
  If Not InstallPlaybackSonarConfiguration Then Exit Function

  Dim compatible As Boolean
  compatible = False
  If Not mConfiguration Is Nothing Then
  compatible = _
    playbackConfiguration.IsPlaybackCompatibleWith(mConfiguration)
  End If
  
  Dim reply As Integer
  If Not compatible Then
    reply = MsgBox("Current sonar configuration is not compatible " & _
                    vbCrLf & "with playback data's configuration. " & vbCrLf & _
                    vbCrLf & "Using playback data's configuration", _
                    vbQuestion + vbOKCancel, "Start Pinging")
    If reply = vbCancel Then
      InstallPlaybackSonarConfiguration = False
      Exit Function
    End If
    Set mConfiguration = playbackConfiguration
  Else
    reply = MsgBox("Use current configuration's processing parameters" & _
                    vbCrLf & "to override playback data's configuration? ", _
                    vbQuestion + vbYesNoCancel, "Start Pinging")
                    
    If reply = vbCancel Then
      InstallPlaybackSonarConfiguration = False
      Exit Function
    ElseIf reply = vbNo Then
      Set mConfiguration = playbackConfiguration
    End If
    
  End If

  InstallPlaybackSonarConfiguration = True
  Exit Function
  
rethrowIt:

  Rethrow "InstallPlaybackSonarConfiguration"
  
End Function
Public Function IsAwake() As Boolean

  IsAwake = sonarIsAwake

End Function

Public Function IsLoopPlayback() As Boolean

  IsLoopPlayback = mIsLoopPlayback

End Function
Public Function IsPaused() As Boolean

  IsPaused = mIsPaused

End Function
Public Function IsPinging() As Boolean

  IsPinging = mIsPinging

End Function
Public Function IsPingLogging() As Boolean

  IsPingLogging = pingLogging

End Function
Public Function isPlayback() As Boolean

  isPlayback = mIsPlayback

End Function
Public Function isUsingAdcpSync() As Boolean

  isUsingAdcpSync = syncEnabled
 
End Function

Public Function IsUsingStoredReplica() As Boolean

  IsUsingStoredReplica = SonarOCX.IsUsingStoredReplica()

End Function
Public Function PingAvailable() As Boolean

  PingAvailable = Not IsEmpty(pingSamples)

End Function

Public Sub PingingPause()

  Debug.Assert (mIsPinging And Not mIsPaused)
  
  mIsPaused = True
  mTimer.enabled = False

End Sub
Public Sub PingingPingOnce(Optional ByVal pingNumber As Variant, _
                           Optional ByVal pingPrevious As Boolean = False)

  'Debug.Assert (IsMissing(pingNumber) Xor pingPrevious)
  
  Dim Message As String
  
  If (Not mIsPinging) Then
    Message = "Sonar has not been started yet."
  ElseIf (Not mPingManually) Then
    Message = "Sonar is not in manual ping mode."
  ElseIf (Not IsMissing(pingNumber) Or pingPrevious) And Not mIsPlayback Then
    Message = "You can only get the next ping when not in playback."
  End If
  
  If Message <> "" Then
    MsgBox Message, vbOKOnly + vbExclamation, "Cannot Issue Single Ping"
    Exit Sub
  End If
  
  If Not IsMissing(pingNumber) Or pingPrevious Then
    If pingPrevious Then pingNumber = mPingNumber - 1
    If pingNumber < 0 Or pingNumber >= mPingCount Then
      MsgBox "Ping number (" & pingNumber & ") is negative or is greater " & _
             vbCrLf & "than the number of pings in the playback ping series (" _
             & mPingCount & ").", vbExclamation + vbOKOnly, "Ping Once"
      Exit Sub
    End If
    PingOnce pingNumber
  Else
  
    PingOnce
    
  End If

End Sub
Public Sub PingingResume()

  Debug.Assert (mIsPinging And mIsPaused)
  
  mIsPaused = False
  PingOnce

End Sub
Public Sub PingingStart()

  Debug.Assert (Not mIsPinging)
  
  If syncEnabled Then SonarOCX.SetButtonChangeCapture True, JOYSTICKID1

  On Error GoTo oops

  Dim cancelled As Boolean
  
  mIsPaused = False
  Dim logging As LoggingTypes
  logging = general.propertyList.GetProperty("General:Logging", ltNone)
  mNPingsLost = 0
  
  If mIsPlayback Then
  
    '  If a ping series hasn't been selected, give them a chance to
    '  select one.
  
    If pingSeriesID = "" Then
      frmPlaybackParameters.GetPlaybackInfo
      If pingSeriesID = "" Then
        MsgBox "No ping series was selected for playback.", vbExclamation, _
               "Pinging Cannot Start"
        Exit Sub
      End If
    End If
    
    SonarInitialize

    ' REB - Tracker 2002.07.10 - need to setup the tracker if we are tracking...
    If trx.IsTracking Then general.sonarIF.trx.PrepareTracker
    
    ' Get the sonar configuration associated with the playback ping series.
    ' If the current configuration is playback compatible with the configuration
    ' used by the ping series, then use that.  Otherwise query the user.
    ' Playback compatible means that the sonar parameters need to be the
    ' same between the two configurations (e.g., classifier, bottom detection,
    ' and echo detection can differ).
    
    Dim ok As Boolean
    ok = InstallPlaybackSonarConfiguration
    If Not ok Then Exit Sub
    
    
    '  Open the playback "file" for the OCX
  
    SonarOCX.OpenPlaybackFile general.pingDB.GetSource, _
                               "Ping", pingSeriesID
    
  Else
  
    ' Start a new ping series, allowing user to enter info in
    ' maintenance mode.
    
    Dim logPings As Boolean
    If general.propertyList.GetProperty("General:OneClickLogging", False) Then
      cancelled = frmPingSeriesInfo.GetNameAndNotes(pingSeriesName, notes, logPings)
      If cancelled Then Exit Sub
      logging = IIf(logPings, ltPings, ltNone)
      general.propertyList.SetProperty "General:Logging", logging, False
    End If
    
    If (general.pingDB.GetFile = "" Or Not general.pingDB.IsOpen()) And logging <> ltNone Then
      MsgBox "No logging database has been selected." & vbCrLf & _
             "Goto SonarConfiguration|Edit|Logging and either " & vbCrLf & _
             "turn off logging, or create/select a log file.", vbExclamation
      Exit Sub
    End If
  
    ' Wake up sonar, if necessary
    
    If Not sonarIsAwake Then
      cancelled = WakeupSonar
      If cancelled Then Exit Sub
    End If
        
    '  Create a new ping series
    
    PingSeriesCreate logging
        
    mPingInterval = mConfiguration.GetValue("pingInterval") * 10 ' from cs to ms
  
  End If

  If mIsPlayback Then
    general.pingDB.Execute "delete * from echo"
    SonarOCX.OpenPingLog general.pingDB.GetSource(), pingSeriesID, _
                         False, True
  ElseIf logging <> ltNone Then
    general.pingDB.Execute "delete * from echo"
    SonarOCX.OpenPingLog general.pingDB.GetSource(), pingSeriesID, _
                         (logging And ltPings) <> 0, (logging And ltEchoes) <> 0
  End If
    
  ConfigureSonarOCX
  mPingNumber = -1
  mIsPinging = True
  If Not mSonarIsRdi2 Then SonarOCX.PingManually = True ' We'll call for each ping as we want it
  If Not mIsPlayback Then
    SonarOCX.StartPinging
  End If
  
  If Not mPingManually And Not mSonarIsRdi2 Then
    PingOnce
  ElseIf mIsPlayback Then
    PingOnce
  End If
  Exit Sub
  
oops:

  mIsPinging = False
  ''''mpinginprogress = False
  mTimer.enabled = False
  mTimerMode = tmIdle
  ErrorBox boxCaption:="Ping Start Failed"

End Sub
Public Sub PingingStop(Optional ByVal abort As Boolean = False)

  Debug.Assert (mIsPinging)
  On Error GoTo oops
  
  Dim stopTime As Date
  stopTime = Now
  
  mIsPinging = False
  mIsPaused = False
  mTimer.enabled = False
  mTimerMode = tmIdle
  
  If mIsPlayback Then
  
    ' Close playback file
    
    SonarOCX.closePlaybackFile
    SonarOCX.closeLogfile
  
  Else
  
    ' Wait for pinging to stop and then update the ping count (if logging)
    
    SonarOCX.StopPinging
    SonarOCX.closeLogfile
    
    '  Allow the user a chance to edit the ping series names and notes
    
    If Not abort Then
    
      If pingSeriesName = "" Then pingSeriesName = pingSeriesID
      If general.propertyList.GetProperty("General:Logging", ltNone) <> ltNone Then _
        frmPingSeriesInfo.GetNameAndNotes pingSeriesName, notes
      
      '  Count the number of pings in the ping series
      
      Dim rs As ADODB.Recordset
      Dim query As String
      query = "select count(*) as nPings from ping where pingseriesid='" & _
              pingSeriesID & "'"
      Set rs = general.pingDB.RecordSetOpen(query)
      Dim nPings As Long
      nPings = rs.Fields("nPings")
      rs.Close
      
      '  Update the ping series record with the number of pings, the stop time,
      '  the name and any notes
      
      query = "update pingSeries set nPings=" & nPings & ", stopTime=#" & stopTime _
              & "#, name='" & SqlStrip(pingSeriesName) & "', notes='" & SqlStrip(notes) & "'" _
              & " where pingseriesid='" & pingSeriesID & "'"
      general.pingDB.Execute query
      
    End If
    
    pingSeriesName = ""
  
  End If
  
  ' Do tracker related clean up / saving iff. tracking is on
  If general.sonarIF.trx.IsTracking Then general.sonarIF.trx.PingingStop
  
  Exit Sub
  
oops:

  ErrorBox boxCaption:="Error While Stopping Pinging"

End Sub
Private Sub PingOnce(Optional ByVal pingNumber)

  Debug.Assert (mIsPinging And Not mIsPaused)
  
  If syncEnabled And Not mIsPlayback Then
  
    '  If using ADCP synchronization then see if we are in an ok
    '  window to ping.  We must be at least syncDelay after the
    '  start of the ADCP ping ensemble start (contained in syncPrevious)
    '  and no later than syncDelayMax after the start.  If we are before
    '  the window, then set the timer to wake us up when the window
    '  starts.  If we're in the window, do the ping.  If we're after the
    '  window, set the timer for the delay time (between adcp start
    '  and sf2k ping).
  

    Dim t As SYSTEMTIME
    GetSystemTime t
    Debug.Print "Ping once called at " & SystemTimeToString(t) & " with adcp start at " & SystemTimeToString(syncPrevious)
    Dim deltaMs As Long
    deltaMs = SystemTimeDifferenceMs(t, syncPrevious)
    If deltaMs < syncDelay Then ' too soon
      mTimer.interval = syncDelay - deltaMs
      mTimer.enabled = True
      
      ' JG - Fix race condition
      If Not mPingManually And Not mIsPaused And mIsPinging Then
        mTimerMode = tmPing
      End If
      Debug.Print "Too soon; waiting " & (syncDelay - deltaMs) & " ms"
      Exit Sub
    ElseIf deltaMs > syncDelayMax Then ' wait for next time
      mTimer.interval = syncDelay
      mTimer.enabled = True
      
      ' JG - Fix race condition
      If Not mPingManually And Not mIsPaused And mIsPinging Then
        mTimerMode = tmPing
      End If
      Debug.Print "Too late; waiting " & syncDelay & " ms"
      Exit Sub
    End If
  
    Debug.Print "In window; pinging"
  End If

  GetSystemTime mPingRequestTime  ' Timestamp the generation event
  
  RaiseEvent PingRequested
  If mIsPlayback Then
    '==> Have OCX delete any echoes for this ping
    
    If Not IsMissing(pingNumber) Then  ' specific ping requested
      SonarOCX.PlaybackPing pingNumber
    Else
    
      ' Playback the next ping, if we haven't run out of pings
    
      If mPingNumber >= mPingCount - 1 Then
        MsgBox "End of ping series reached.", vbOKOnly + vbInformation, _
               "Playback Over"
        PingingStop
        RaiseEvent EndOfPingSeries
      Else
        SonarOCX.PlaybackPing mPingNumber + 1
      End If
    End If
  
  Else  ' Issue a real ping!
  
    Dim lat As Double
    Dim lon As Double
    Dim theTime As Date
    Dim usingGps As Boolean
    
    usingGps = (general.Gps.GetGpsState() = gpsActive)
    If usingGps Then
      general.Gps.GetGPSLatLonTime lat, lon, theTime
    End If
    SonarOCX.PingOnce usingGps, lat, lon, theTime
  
  End If

End Sub
Private Sub PingSeriesCreate(ByVal logging As LoggingTypes)

  On Error GoTo rethrowIt

'Adds a new PingSeries record to the current ping database.
'Adds a SonarParameters record to the current ping database, if needed.

  Dim sonarConfigurationId As String
  
  If logging <> ltNone Then mConfiguration.ExportToDB general.parametersDb, general.pingDB
  sonarConfigurationId = mConfiguration.GetValue("sonarconfigurationid")
  
  Dim classifier As ClassifierClass
  Set classifier = mConfiguration.GetClassifier()
  If Not classifier Is Nothing And logging <> ltNone Then
    classifier.ExportToDB general.parametersDb, general.pingDB
  End If
  
  Dim replica As ReplicaClass
  Set replica = mConfiguration.GetReplica()
  If Not replica Is Nothing And logging <> ltNone Then
    replica.ExportToDB general.parametersDb, general.pingDB
  End If

  '  Create a ping series id
  
  Dim theTime As Date
  theTime = Now
  transducerID = general.propertyList.GetProperty("General:TransducerID", "")
  If transducerID = "" Then
    transducerID = CLng(Rnd() * 100000)
    general.propertyList.SetProperty "General:TransducerID", transducerID
  End If
  pingSeriesID = transducerID & Format(theTime, ":yyyymmddHhNnSs")
  
  '  Write a ping series record out
  
  If logging = ltNone Then Exit Sub
  
  Dim rs As ADODB.Recordset
  Set rs = general.pingDB.RecordSetOpen("PingSeries", options:=adCmdTable)
  rs.AddNew
  rs.Fields("startTime") = theTime
  rs.Fields("stopTime") = theTime
  rs.Fields("transducerSerialNumber") = GetTransducerID()
  rs.Fields("pingSeriesID") = pingSeriesID
  rs.Fields("Name") = pingSeriesName
  rs.Fields("speedofsound") = speedOfSound
  rs.Fields("salinity") = salinity
  rs.Fields("sonarConfigurationId") = sonarConfigurationId
  If notes <> "" Then rs.Fields("notes").AppendChunk (notes)
  rs.Update
  rs.Close
  
  Exit Sub
  
rethrowIt:

  Rethrow "PingSeriesCreate"

End Sub

Public Function PlotFillArray(appliedFunction As AppliedFunctions, _
                              arraySize As Long, _
                              baseLevel As Single, _
                              first As Long, _
                              last As Long, _
                              xScale As Single, _
                              xMin As Single, _
                              Y, _
                              x2, _
                              y2) As Long
                              
  '  Just a pass-through
                              
  PlotFillArray = SonarOCX.PlotFillArray(appliedFunction, _
   1024, baseLevel, first, last, xScale, xMin, Y, x2, y2)

End Function
Public Sub removePingListener(theListener As Object)

  Dim i As Long
  Dim listener As PingListener

  For i = pingListeners.count To 1 Step -1
    If pingListeners(i).theObject Is theListener Then
      pingListeners.Remove i
    End If
  Next i
  
  sonarDataFlags = 0
  For Each listener In pingListeners
    sonarDataFlags = sonarDataFlags Or listener.flags
  Next listener

End Sub
    
Public Sub reset()

  IllegalForPlaybackMode
  sonarIsAwake = False
  SonarOCX.reset

End Sub

Public Sub setAdcMaxVoltage(ByVal value As Single)

  SonarOCX.AdcMaxVoltage = value
  
End Sub
Public Sub setAdcMinVoltage(ByVal value As Single)

  SonarOCX.AdcMinVoltage = value
  
End Sub
Public Sub setBandwidth(ByVal bw As BandwidthT)

  IllegalForPlaybackMode
  SonarOCX.Bandwidth = bw

End Sub
Public Sub SetBaudRate(ByVal baudRate As Long)

  SonarOCX.baudRate = baudRate

End Sub
Public Sub SetBottomDetectFalloffRatio(ByVal newValue As Single)

  bottomDetectFalloffRatio = newValue
  SetBottomDetectionParameters
  
End Sub
Public Sub SetBottomDetectionParameters(Optional ByVal newFalloffRatio As Variant, _
                                          Optional ByVal newStartRange As Variant, _
                                          Optional ByVal newThreshold As Variant, _
                                          Optional ByVal newWindowSize As Variant)

  If Not IsMissing(newFalloffRatio) Then bottomDetectFalloffRatio = newFalloffRatio
  If Not IsMissing(newStartRange) Then bottomDetectStartRange = newStartRange
  If Not IsMissing(newThreshold) Then bottomDetectThreshold = newThreshold
  If Not IsMissing(newWindowSize) Then bottomDetectWindowSize = newWindowSize
  
  SonarOCX.SetBottomDetectionParameters bottomDetectFalloffRatio, _
                                        bottomDetectStartRange, _
                                        bottomDetectThreshold, _
                                        bottomDetectWindowSize

End Sub
Public Sub SetBottomDetectStartRange(ByVal newValue As Single)

  bottomDetectStartRange = newValue
  SetBottomDetectionParameters
  
End Sub
Public Sub SetBottomDetectThreshold(ByVal newValue As Single)

  bottomDetectThreshold = newValue
  SetBottomDetectionParameters
  
End Sub
Public Sub SetBottomDetectWindowSize(ByVal newValue As Single)

  bottomDetectWindowSize = newValue
  SetBottomDetectionParameters
  
End Sub
Public Sub SetCharacterSize(ByVal CharacterSize As Long)

  SonarOCX.CharacterSize = CharacterSize

End Sub
Public Sub SetClassifier(classifier As ClassifierClass)

  Dim exportFile As String
  
  If classifier Is Nothing Then
    SonarOCX.SetClassifier "", 0, 0, 0, 0  ' Remove classifier
  Else
    With classifier
    
      exportFile = general.appOrigin & "\data\classifier.tmp"
      .ExportNet exportFile
      SonarOCX.SetClassifier exportFile, .GetNClasses(), .GetFirstBin(), .GetNBins, _
                             .GetSamplingPeriod()
      If .GetSamplingPeriod <> SamplingPeriod Then
        MsgBox "Warning: classifier sampling period, " & .GetSamplingPeriod & _
               "ns, is not equal to sonar sample period, " & SamplingPeriod & _
               "ns.", vbOKOnly + vbExclamation, "Classifier/DSP Mismatch"
      End If
    End With
  End If

End Sub

Public Sub SetEchoDetectionParameters(Optional ByVal newPeakThreshold As Variant, _
                                      Optional ByVal newPeakSeparation As Variant, _
                                      Optional ByVal newWindowSize As Variant, _
                                      Optional ByVal newTargetStrengthThreshold As Variant, _
                                      Optional ByVal newEchoAvgMaxRange)

  If Not IsMissing(newPeakThreshold) Then echoDetectPeakThreshold = newPeakThreshold
  If Not IsMissing(newPeakSeparation) Then echoDetectPeakSeparation = newPeakSeparation
  If Not IsMissing(newWindowSize) Then echoDetectWindowSize = newWindowSize
  ' JG - If Not IsMissing(newTargetStrengthThreshold) Then newTargetStrengthThreshold = newTargetStrengthThreshold
  If Not IsMissing(newTargetStrengthThreshold) Then echoDetectTargetStrengthThreshold = newTargetStrengthThreshold
  If Not IsMissing(newEchoAvgMaxRange) Then echoDetectAvgMaxRange = newEchoAvgMaxRange

  SonarOCX.SetEchoDetectionParameters echoDetectPeakThreshold, _
                                      echoDetectPeakSeparation, _
                                      echoDetectWindowSize, _
                                      echoDetectTargetStrengthThreshold, _
                                      echoDetectAvgMaxRange

End Sub
Public Sub SetEnableSync(ByVal enable As Boolean, Optional delay As Variant, _
                         Optional delayMax As Variant)
                         
  If Not IsMissing(delay) Then syncDelay = delay
  If Not IsMissing(delayMax) Then syncDelayMax = delayMax

  On Error GoTo oops
  Dim ok As Boolean
  ok = SonarOCX.SetButtonChangeCapture(enable, JOYSTICKID1)
  syncEnabled = enable
  general.propertyList.SetProperty "Norway:useAdcpSync", enable
  GetSystemTime syncPrevious
  Exit Sub
  
oops:
  MsgBox "Could not access sync device: " & vbCrLf & Err.description, _
         vbCritical, "SetEnableSync failed."
  general.propertyList.SetProperty "Norway:useAdcpSync", False
  syncEnabled = False

End Sub
Public Sub SetExemplarFFTSize(ByVal newValue As Long)

  SonarOCX.exemplarFFTSize = newValue

End Sub
Public Sub SetLoopPlayback(ByVal setIt As Boolean)

  Debug.Assert (mIsPlayback And Not mIsPinging)
  
  mIsLoopPlayback = setIt

End Sub
Public Sub SetManualPing(ByVal manual As Boolean)

  Debug.Assert (Not mIsPinging)

  mPingManually = manual

End Sub

Public Sub SetNarrowBeam(ByVal narrow As Boolean)

  IllegalForPlaybackMode
  SonarOCX.narrowBeam = narrow

End Sub
Public Sub SetNoiseThreshold(ByVal value As Single)

  SonarOCX.noiseThreshold = value
  
End Sub
Public Sub SetNoiseWindowSize(ByVal value As Long)

  SonarOCX.noiseWindowSize = value
  
End Sub
Public Sub SetNotes(ByVal theNotes As String)

  notes = theNotes

End Sub
Public Sub SetParity(ByVal Parity As Integer)

  SonarOCX.Parity = Parity

End Sub
Public Sub SetPeakSeparation(ByVal value As Single)

  echoDetectPeakSeparation = value
  SetEchoDetectionParameters
  
End Sub
Public Sub SetPeakThreshold(ByVal value As Single)

  echoDetectPeakThreshold = value
  SetEchoDetectionParameters
  
End Sub
Public Sub SetPeakWindowSize(ByVal value As Long)

  echoDetectWindowSize = value
  SetEchoDetectionParameters
  
End Sub
Public Sub SetPingCount(ByVal count As Long)

  mPingCount = count

End Sub

Public Sub SetPingInterval(ByVal interval As Long)

  IllegalForPlaybackMode
  If Not mIsPlayback Then SonarOCX.pingInterval = interval

End Sub
Public Sub SetPingLogging(ByVal newValue As Boolean)

  pingLogging = newValue

End Sub
Public Sub SetPingSeriesID(ByVal newID As String)

  Debug.Assert (Not mIsPinging And mIsPlayback)
  pingSeriesID = newID

End Sub

Public Sub SetPingSeriesName(ByVal name As String)

  pingSeriesName = name

End Sub

Public Sub SetPlaybackMode(ByVal value As Boolean)

  mIsPlayback = value

End Sub


Public Sub setPulseLength(ByVal length As Long)

  IllegalForPlaybackMode
  SonarOCX.pulseLength = length

End Sub

Public Sub setPulseType(ByVal theType As PulseTypeT)

  IllegalForPlaybackMode
  SonarOCX.pulseType = theType

End Sub

Public Sub setReceiverGain(ByVal gain As ReceiverGainT)

  IllegalForPlaybackMode
  SonarOCX.receiverGain = gain

End Sub
Public Sub SetSalinity(ByVal value As Long)

  salinity = value

End Sub
Public Sub setSampleCount(ByVal count As Long)

  IllegalForPlaybackMode
  SonarOCX.sampleCount = count
  sampleCount = count

End Sub
Public Sub SetSamplingPeriod(ByVal period As Long)

  IllegalForPlaybackMode
  SonarOCX.SamplingPeriod = period
  SamplingPeriod = period

End Sub
Public Sub SetSonarConfiguration(configuration As SonarConfigurationClass)

  Debug.Assert Not mIsPinging
  
  Set mConfiguration = configuration

End Sub
Public Sub SetSpeedOfSound(ByVal speed As Integer)

  IllegalForPlaybackMode
  SonarOCX.speedOfSound = speed

End Sub
Public Sub setStartFrequency(ByVal frequency As Long)

  IllegalForPlaybackMode
  SonarOCX.startFrequency = frequency

End Sub
Public Sub setStopFrequency(ByVal frequency As Long)

  IllegalForPlaybackMode
  SonarOCX.stopFrequency = frequency
  
End Sub
Public Sub SetTargetStrengthThreshold(ByVal value As Single)

  echoDetectTargetStrengthThreshold = value
  SetEchoDetectionParameters
  
End Sub
Public Sub setTransmitPower(ByVal power As Integer)

  IllegalForPlaybackMode
  SonarOCX.transmitPower = power

End Sub
Public Sub SetTransducerID(ByVal newValue As String)

  transducerID = newValue

End Sub
Public Sub SetUseStoredReplica(ByVal newValue As Boolean)

  SonarOCX.SetUseStoredReplica newValue
  
End Sub
Private Sub SonarInitialize()

  Dim sonarIsRdi2 As Boolean
  mSonarIsRdi2 = general.propertyList.GetProperty("General:SonarIsRdi2", True)
  SonarOCX.Initialize (mSonarIsRdi2)
  mSonarIsInitialized = True

End Sub
Public Function WakeupSonar() As Boolean

  Dim cancelled As Boolean
  Dim reply As String
  cancelled = False
  
  If Not mSonarIsInitialized Then
    
    If general.maintenanceMode Then
    
      ' Allow changing between modes in maintenance mode
      
      Dim useNew As Boolean
      useNew = general.propertyList.GetProperty("General:SonarIsRdi2", True)
      Dim captions(0 To 1) As String
      captions(0) = "&New"
      captions(1) = "&Old"
      reply = frmAlertBox.alertBoxShow("Which hardware interface should be used?", _
                                       abiQuestion, abbCustom1 + abbCustom2, _
                                       "Hardware Interface", _
                                       customButtonCaptions:=captions, _
                                       defaultButton:=IIf(useNew, abbCustom1, abbCustom2))
      general.propertyList.SetProperty "General:SonarIsRdi2", _
                                       reply = abbCustom1
    End If
    
    SonarInitialize
  End If
  
  If mSonarIsRdi2 Then
  
    SonarOCX.SetCommParameters2 _
      general.propertyList.GetProperty("SonarCommPort", 6), _
      general.propertyList.GetProperty("SonarBaudrate", 115200)
  
  Else

    Do
      With general.propertyList
      
        '  Get the current comm settings
      
        SonarOCX.baudRate = .GetProperty("SonarBaudrate", 9600)
        SonarOCX.CharacterSize = .GetProperty("SonarCharacterSize", 8)
        SonarOCX.CommPort = .GetProperty("SonarCommPort", 1)
        SonarOCX.Parity = .GetProperty("SonarParity", pvNone)
        
        If general.Gps.IsOpen And general.Gps.GetCommPort() = SonarOCX.CommPort Then
          MsgBox "GPS is active and is using the same Com port as the sonar." _
                  & vbCrLf & vbCrLf & "Your options are:" & vbCrLf & _
                  vbCrLf & "1 - Deactivate GPS (use System|GPS Configuration)" & _
                  vbCrLf & vbCrLf & "2 - Specify another port for the sonar " _
                  & vbCrLf & "......(use System|Sonar Configuration then Edit|Sonar Communcation)", _
                  vbOKOnly + vbExclamation, "Com Port Conflict"
          WakeupSonar = True
          Exit Function
        End If
      End With
        
      '  Try to wake up the sonar
      
      reset
      
      '  Wait for up to 10 seconds for sonar to wakeup
      
      Dim i As Integer
      For i = 1 To 40
        If sonarIsAwake Then Exit For
        DoEvents
        Sleep 100
      Next i
      
      If Not sonarIsAwake Then
      
        '  Sonar is not awake.  Offer user some options:
        
        Dim invalid As Boolean
        Do
        
          '  Loop til we get a valid choice
        
          reply = InputBox("Failed to make contact with the sonar.  Select an action" _
                            & vbCrLf & vbCrLf & _
                            "1 - Try again" & vbCrLf & _
                            "2 - Change communications parameters" & vbCrLf & _
                            "3 - Abort", "Sonar Not Awakened", "1")
                                
          If reply = "" Then
            reply = 3
            invalid = False
          ElseIf Not IsNumeric(reply) Then
            invalid = True
          ElseIf Not inSet(reply, 1, 2, 3) Then
            invalid = True
          Else
            invalid = False
          End If
          If invalid Then MsgBox "Please enter 1, 2 or 3", vbOKOnly + vbExclamation, _
                                 "Invalid Action"
        Loop Until Not invalid
        
        '  Act on the choices; default is to try again
        
        If reply = 3 Then
          cancelled = True     ' give up
        ElseIf reply = 2 Then
          frmCommParameters.Show 1  ' try to change the comm parameters
          If Not sonarIsAwake Then
            cancelled = True
          End If
        End If
      End If
    
    Loop Until cancelled Or sonarIsAwake
      
  End If
  
  WakeupSonar = cancelled

End Function

Private Sub SonarOCX_ButtonChange(ByVal buttonNumber As Integer, _
  ByVal buttonIsUp As Boolean, ByVal t_year As Integer, _
  ByVal t_month As Integer, ByVal t_day As Integer, ByVal t_hour As Integer, ByVal t_minute As Integer, ByVal t_second As Integer, _
  ByVal t_msec As Integer)
  
  
  Dim timestamp As SYSTEMTIME
  With timestamp
    .wYear = t_year
    .wMonth = t_month
    .wDay = t_day
    .wHour = t_hour
    .wMinute = t_minute
    .wSecond = t_second
    .wMilliseconds = t_msec
  End With

  Dim deltaMs As Long

  If (buttonIsUp) Then
  
    ' Only process this event occurs if it occurs at least a wait-delay
    ' time after the previously accepted event
    
    deltaMs = SystemTimeDifferenceMs(timestamp, syncPrevious)
    Debug.Print "Button up at " & SystemTimeToString(timestamp)
    
    If deltaMs > syncDelay Then
    
      syncPrevious = timestamp
        
    End If
  
  End If


End Sub

Private Sub SonarOCX_ParameterChange(ByVal parameterCode As Integer)
  
  Select Case parameterCode
    Case ssBandwidth
      Bandwidth = SonarOCX.Bandwidth
    
    Case ssNarrowBeam
      narrowBeam = SonarOCX.narrowBeam
      
    Case ssPingInterval
      pingInterval = SonarOCX.pingInterval
    
    Case ssPingManually
      'mPingManually = SonarOCX.PingManually
    
    Case ssPulseLength
      pulseLength = SonarOCX.pulseLength
    
    Case ssPulseType
     pulseType = SonarOCX.pulseType
    
    Case ssReceiverGain
       receiverGain = SonarOCX.receiverGain
       
    Case ssSpeedOfSound
      speedOfSound = SonarOCX.speedOfSound
      
    Case ssStartFrequency
      startFrequency = SonarOCX.startFrequency
      
    Case ssStopFrequency
      stopFrequency = SonarOCX.stopFrequency
      
    Case ssTransmitPower
      transmitPower = SonarOCX.transmitPower
      
    Case ssWakeup
      sonarIsAwake = True
      
      ' Wait two seconds to let messages come in, then refresh
      
      Dim start As Single
      
      start = Timer ' Set start time
      Do While Timer < start + 2
        DoEvents  ' Yield to other processes.
      Loop
        
  '    RefreshAllParameters
      
    Case ssError
      errorMessage = SonarOCX.errorMessage
      If Trim(errorMessage) <> "" Then _
        MsgBox "RDI unit system error:" & Chr(13) & Chr(10) & errorMessage, vbCritical
       
    Case Else
      Debug.Assert (False) ' Another case needs to be added if this trips...
      
  End Select

End Sub

Private Sub SonarOCX_Ping(ByVal p_pingNumber As Long)

  Dim theEcho As EchoClass
  Dim i As Long
  Dim length As Long
  Dim listener As PingListener
  Dim newDetectionSignalLength As Long
  Dim newTimeSeriesLength As Long
  Dim ok As Boolean
  Dim spectrumSize As Long

  If p_pingNumber >= 0 Then ' negative number signals ping failure
    
    mPingNumber = p_pingNumber
    pingInProgress = False
    RaiseEvent PingReceived
    
    If pingListeners.count <> 0 Then
    
      ok = SonarOCX.LockPing(p_pingNumber)
      
      If Not ok Then
        Debug.Print "SonarClass:PingArrived: Ping Lock failed for ping " & p_pingNumber
        Exit Sub
      End If
          
      SonarOCX.GetOutputInfo newTimeSeriesLength, _
        newDetectionSignalLength, nEchoes, spectrumSize, pingTime, pingLatitude, pingLongitude
        
        '  Retrieve any of the sonar outputs needed by listeners
        
      If sonarDataFlags And sonarDataTimeSeries Then
        If timeSeriesLength <> newTimeSeriesLength Then
          timeSeriesLength = newTimeSeriesLength
          ReDim timeSeries(0 To timeSeriesLength - 1)
        End If
        SonarOCX.RetrieveTimeSeries (timeSeries)
      End If
      
      If sonarDataFlags And sonarDataMatchedFilter Then
        If detectionSignalLength <> newDetectionSignalLength Then
          detectionSignalLength = newDetectionSignalLength
          ReDim detectionSignal(0 To detectionSignalLength - 1)
        End If
        SonarOCX.RetrieveDetectionSignal (detectionSignal)
      End If
      
      If sonarDataFlags And sonarDataEchoes Then
      
        ' Flush the old echoes
        
        For i = echoes.count To 1 Step -1
          echoes.Remove i
        Next i
        
        ' Upload the new echoes
    
        For i = 0 To nEchoes - 1
          Set theEcho = New EchoClass
          theEcho.Upload i, spectrumSize, SonarOCX
          echoes.Add theEcho
        Next i
     
      End If

      '  Notify all listeners that a ping has arrived
      
      For Each listener In pingListeners
        listener.theObject.PingArrived p_pingNumber
      Next listener
         
      SonarOCX.UnlockPing (p_pingNumber)
    End If
  Else
    mNPingsLost = mNPingsLost + 1
  End If
    
  If Not mIsPlayback And mPingNumber Mod 30 = 0 And general.pingDB.IsOpen And _
     general.propertyList.GetProperty("General:Logging", ltNone) <> ltNone Then
    If FileLen(general.pingDB.GetFile) > 500000000 Then '500000000
      Beep
      Beep
      Beep
      MsgBox "Ping logging database contains more than 500MB." & vbCrLf & _
             "You will need to start a new database before resuming pinging", _
             vbOKOnly + vbExclamation, "Pinging Terminated"
      PingingStop
      general.pingDB.dbClose
      Exit Sub
    End If
  End If
  
  If Not mPingManually And Not mIsPaused And mIsPinging Then
  
    '  Determine how long we need to wait before sending out the
    '  next ping, set the timer, then leave.
    
    Dim theTime As SYSTEMTIME
    GetSystemTime theTime
    Dim deltaMs As Long
    deltaMs = SystemTimeDifferenceMs(theTime, mPingRequestTime)
    
    mTimerMode = tmPing
    
    If deltaMs > mPingInterval Then
      mTimer.interval = 100 ' Allow a little slop
    Else
      mTimer.interval = mPingInterval - deltaMs
    End If
    
    mTimer.enabled = True
  
  End If
  
End Sub

Private Sub SonarOCX_ReadyToCollect(ByVal ready As Boolean)

  If ready Then
    If Not mPingManually Then PingOnce
  Else
    PingingStop abort:=True
  End If

End Sub

Private Sub SonarOCX_SonarError(ByVal code As Integer, ByVal severity As Integer, Message As String)
  
  '  This event is generated when an asynchronous error occurs in
  '  the sonar system.  Eventually, we'll have to respond to the
  '  errors in a more sophisticated manner: some will require
  '  terminating pinging/playback, others may allow users to suppress
  '  warnings in the future, etc.

  If (InStr(1, Message, "Ping read failure:") <> 0) Then Exit Sub
  On Error Resume Next
  
  If lastSonarError = Message Then ' avoids hitting the user repeatedly w/ the same error... REB
    Beep
    ' may want to do some other sort of notification...
  Else
    lastSonarError = Message
  End If
  
  frmAlertBox.alertBoxShow Message, abiExclamation, title:="Sonar System Error", _
                           expireInSeconds:=10

End Sub
Private Sub Class_Initialize()

  bandwidthTable(-1) = "UNK"
  bandwidthTable(0) = "UNK"
  bandwidthTable(bw50) = "50%"
  bandwidthTable(bw25) = "25%"
  bandwidthTable(bw12_5) = "12.5%"
  bandwidthTable(bw6_25) = "6.25%"
  
  receiverGainTable(-1) = "UNK"
  receiverGainTable(rgLow) = "low"
  receiverGainTable(rgMedium) = "medium"
  receiverGainTable(rgHigh) = "high"
  receiverGainTable(rgVeryHigh) = "very high"
  
  mPingNumber = -1
  pingInProgress = False
  mIsPlayback = False
  mPingManually = False
  ReDim pingSamplesInternal(0 To 1)
  timeSeriesLength = 0
  detectionSignalLength = 0
  nEchoes = 0
  Set echoes = New Collection

End Sub

Private Sub mTimer_Timer()

  mTimer.enabled = False
  
  Select Case mTimerMode
  
    Case tmIdle
      ' do nothing
      
    Case tmPing
     
      PingOnce
      
    Case tmWakeup
    
  End Select

End Sub

Public Function Tracker_SetParamAlphaBeta(ByVal alpha As Double, _
                                     ByVal beta As Double, _
                                     ByVal gate As Long) As Long
                                    
  On Error GoTo oops:
  
  Tracker_SetParamAlphaBeta = SonarOCX.SetTrackerParamAlphaBeta(alpha, beta, gate)
  
  If (Tracker_SetParamAlphaBeta <> 0) Then
    MsgBox "The JPDA algorithm's parameters couldn't be set." & vbCrLf & _
           "Data collection/playback can continue normally.", , title:="Algorithm Setup Failed:"
    Debug.Assert (False)
    trx.SuspendTracking
    Exit Function
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_SetParamAlphaBeta"
  
End Function

Public Function Tracker_SetParamJPDA(ByVal alpha As Double, _
                                ByVal beta As Double, _
                                ByVal initGate As Double, _
                                ByVal probOfDetect As Double, _
                                ByVal extraneousDetect As Double) As Long
                                    
  On Error GoTo oops:
  
  Tracker_SetParamJPDA = SonarOCX.SetTrackerParamJPDA(alpha, beta, _
                                initGate, probOfDetect, extraneousDetect)
  If (Tracker_SetParamJPDA <> 0) Then
    MsgBox "The JPDA algorithm's parameters couldn't be set." & vbCrLf & _
           "Data collection/playback can continue normally.", , title:="Algorithm Setup Failed:"
    Debug.Assert (False)
    trx.SuspendTracking
    Exit Function
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_SetParamJPDA"
  
End Function

Public Function Tracker_GetTrackAssoc(ByVal pingNum As Long, _
                                        ByVal echoNum As Long) As Long
  On Error GoTo oops:
  
  Tracker_GetTrackAssoc = SonarOCX.GetTrackAssoc(pingNum, echoNum)
  
  If Not IsBetween(Tracker_GetTrackAssoc, -2, 10000) Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
  '''''''''''''''''''''' testing - remove later '''''''''''''''''''''''
  Dim outstring As String
  Dim mPingNum As Long
  Dim mEchoNum As Long
  If echoNum <> 0 Then Exit Function
  
  For mPingNum = 0 To pingNum
    outstring = outstring & "For Ping # " & mPingNum & vbCrLf
    For mEchoNum = 0 To SonarOCX.GetNumEchoesInPing(mPingNum) - 1
    Tracker_GetTrackAssoc = SonarOCX.GetTrackAssoc(mPingNum, mEchoNum)
    outstring = outstring & "Echo# " & mEchoNum & " has a track @ # = " & Tracker_GetTrackAssoc & vbCrLf
                
    Next mEchoNum
  Next mPingNum
  frmShowReport.Execute outstring
  
  Exit Function
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_GetTrackAssoc"
  
End Function

Public Function Tracker_GetAverageTS(ByVal trackNum As Long) As Double

  On Error GoTo oops:
  Debug.Assert (trackNum >= 0) And (trackNum < 10000)
  
  Tracker_GetAverageTS = SonarOCX.GetTrackAvgTS(trackNum)
  
  If Not ReasonableTS(Tracker_GetAverageTS) Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_GetAverageTS"
  
End Function

Public Function Tracker_NumEchoesInPing(ByVal pingNum As Long) As Long

  On Error GoTo oops:
  
  Debug.Assert pingNum >= 0 And pingNum < 10000
  
  Tracker_NumEchoesInPing = SonarOCX.GetNumEchoesInPing(pingNum)
  
  ' check rtn value
  If Not IsBetween(Tracker_NumEchoesInPing, -1, 400) Then
    Debug.Assert (False)
    Tracker_NumEchoesInPing = 0
    trx.SuspendTracking
  End If
    
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_NumEchoesInPing"

End Function
        
Public Function Tracker_getParentEcho(ByVal childPingNum As Long, _
              ByVal childEchoNum As Long, parentPingNum As Long, _
              parentEchoNum As Long) As Integer
              
  On Error GoTo oops:

  Debug.Assert (childEchoNum >= 0)
  Debug.Assert (childEchoNum >= 0)
  Debug.Assert (childEchoNum < SonarOCX.GetNumEchoesInPing(childPingNum))
  
  Tracker_getParentEcho = SonarOCX.GetParentInTrack((childPingNum), _
                          (childEchoNum), parentPingNum, parentEchoNum)
  
  If (Not IsBetween(parentPingNum, -1, childPingNum) Or Not _
        IsBetween(parentEchoNum, -1, SonarOCX.GetNumEchoesInPing(parentPingNum))) _
        And Tracker_getParentEcho <> -1002 Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  Exit Function
  
  '''''''''''''''''''''' testing - remove later '''''''''''''''''''''''
  Dim outstring As String
  Dim pingNum As Long
  Dim echoNum As Long
  For pingNum = 1 To childPingNum
    outstring = outstring & "For Ping # " & pingNum & vbCrLf
    For echoNum = 0 To SonarOCX.GetNumEchoesInPing(pingNum) - 1
    Tracker_getParentEcho = SonarOCX.GetParentInTrack((pingNum), _
                          (echoNum), parentPingNum, parentEchoNum)
    outstring = outstring & "Echo# " & echoNum & " has a parent @ Ping# = " & parentPingNum _
                & "Echo# = " & parentEchoNum & vbCrLf
    Next echoNum
  Next pingNum
  frmShowReport.Execute outstring
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Exit Function

oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_getParentEcho"
  
End Function

Public Function Tracker_getEchoRange(ByVal pingNum As Long, ByVal echoNum As Long) As Double

  On Error GoTo oops:
  
  Debug.Assert ((pingNum > -1 And pingNum < 100000) Or pingNum = -1002)
  Debug.Assert ((echoNum > -1 And echoNum < 100000) Or echoNum = -1002)
  
  Tracker_getEchoRange = SonarOCX.GetEchoRange(pingNum, echoNum)
  
  If Not ReasonableRange(Tracker_getEchoRange) Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_getEchoRange"
  
  End Function

Public Function Tracker_getAverageTSOfTrack(ByVal trackNum As Long) As Double

  On Error GoTo oops:
  
  Debug.Assert (trackNum > -1 And trackNum < 10000)
  
  Tracker_getAverageTSOfTrack = SonarOCX.GetTrackAvgTS(trackNum)
  
  If Not ReasonableTS(Tracker_getAverageTSOfTrack) Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_getAverageTSOfTrack"
  
End Function

Public Function Tracker_GetCountByClass(ByVal minRange As Double, _
                                        ByVal maxRange As Double, _
                                        ByVal classification As Long, _
                                        ByVal earliestStart As Long, _
                                        ByVal latestEnd As Long) As Long
                                    
  On Error GoTo oops:
    
  Debug.Assert ReasonableRange(minRange)
  Debug.Assert ReasonableRange(maxRange)
  Debug.Assert ReasonableClassification(classification)
  Debug.Assert earliestStart > -1
  Debug.Assert latestEnd < 10000
  
  Tracker_GetCountByClass = SonarOCX.GetNumTracksInClass(minRange, _
                                  maxRange, classification, earliestStart, latestEnd)
  
  If Not ReasonableClassification(Tracker_GetCountByClass) Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_GetCountByClass"
  
End Function

Public Function Tracker_GetCountTracksByTS(minRange As Double, _
                                    maxRange As Double, _
                                    minTS As Double, _
                                    maxTS As Double, _
                                    earliestStart As Long, _
                                    latestEnd As Long) As Long
  On Error GoTo oops:
  
  Debug.Assert ReasonableRange(minRange)
  Debug.Assert ReasonableRange(maxRange)
  Debug.Assert earliestStart > -1
  Debug.Assert latestEnd < 10000
  
  Tracker_GetCountTracksByTS = SonarOCX.GetNumTracksByTS(minRange, _
                                   maxRange, minTS, maxTS, earliestStart, latestEnd)
                                   
  If Tracker_GetCountTracksByTS < 0 Then
    Debug.Assert (False)
    trx.SuspendTracking
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_GetCountTracksByTS"
  
End Function

Public Function Tracker_ChangeTrackerState(ByVal state As Integer) As Long

  On Error GoTo oops:

  Debug.Assert (state > 0) And (state < 5)
  
  Tracker_ChangeTrackerState = SonarOCX.ChangeTrackerState(DISABLE_TRACKING) 'turn tracking off first
  If (Tracker_ChangeTrackerState <> 0) Then
    MsgBox "The trackering algorithm counldn't be initalized." & vbCrLf & _
           "Data collection/playback can continue normally.", , title:="Tracker Initialization Failed:"
    Debug.Assert (False)
    trx.SuspendTracking
    Exit Function
  End If
  
  Tracker_ChangeTrackerState = SonarOCX.ChangeTrackerState(state)
  If (Tracker_ChangeTrackerState <> 0) Then
    MsgBox "The trackering algorithm counldn't be setup." & vbCrLf & _
           "Data collection/playback can continue normally.", , title:="Tracker Setup Failed:"
    Debug.Assert (False)
    trx.SuspendTracking
    Exit Function
  End If
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "Tracker_ChangeTrackerState"
  
End Function

Private Function ReasonableTS(ByVal ts As Double) As Boolean

  ReasonableTS = IsBetween(ts, -100, 100)

End Function

Private Function ReasonableRange(ByVal range As Double) As Boolean

  ReasonableRange = IsBetween(range, 0, 400, exclusive:=False)

End Function

Private Function ReasonableClassification(ByVal classification As Integer) As Boolean

  ReasonableClassification = IsBetween(classification, -3, 12, exclusive:=False)

End Function
